<?php

namespace App\Controllers;

/**
 * UserController class
 */
class WebcamController
{
	/**
	 * Show the requested user
	 *
	 * @param  string $id
	 *
	 * @return string
	 */

  public function show($id) {
    $response = __FUNCTION__.' triggerd in '.__CLASS__.' argument value: '.$id;
    return $response;
  }

  /**
   * Kamery
   * @var null
   */
  public function showAll() {
    $localization  = FALSE;
    $spot     = get_spot();
    $mapper   = $spot->mapper('App\Entity\Localization');
    $response = $mapper->all();
    if (is_object($response)){
      $localization = array();
      foreach ($response as $item) {
        $localization[] = (object) array (
          'id'           => $item->camera_id,
		  'country'	 	 => $item->country,
		  'region'	 	 => $item->region,
		  'city'	 	 => $item->city,
		  'lat'	 	 	 => $item->lat,
		  'lng'	 	 	 => $item->lng,
        );
      }
    }
    return $json_string = json_encode($localization, JSON_PRETTY_PRINT);
  }
  
  public function showCamera($id) {
    $camera   = FALSE;
    $spot     = get_spot();
    $mapper   = $spot->mapper('App\Entity\Camera');
    $response = $mapper->get($id);
    if (is_object($response)){
      $camera = array();
        $camera = (object) array (
          'id'           => $response->id,
		  'url'	 	 	 => $response->url,
		  'stream'	 	 => $response->stream,
		  'screen'	 	 => $response->screen,
		  'localization' => (object) array(
			'country'	 => $response->localization->country,
			'region'	 => $response->localization->region,
			'city'	 	 => $response->localization->city,
			'lat'	 	 => $response->localization->lat,
			'lng'	 	 => $response->localization->lng
		  ),
		  'counters' 	 => (object) array(
			'likes'	 	 => $response->counter->likes,
			'warns'	 	 => $response->counter->warns,
			'views'	 	 => $response->counter->views
		  ),
		  'tags' 		 => (object) array(
			'tag'	 	 => $response->tag->tag
		  ),
		  'works' 		 => (object) array(
			'work'	 	 => $response->work->work
		  ),
        );
    }
    return str_replace('\/','/', $json_string = json_encode($camera, JSON_PRETTY_PRINT));
  }
  
  public function likeSort() {
    $counter   = FALSE;
    $spot     = get_spot();
    $mapper   = $spot->mapper('App\Entity\Counter');
    $response = $mapper->sortLike();
    if (is_object($response)){
      $counter = array();
      foreach ($response as $item) {
        $counter[] = (object) array (
          'id'           => $item->camera_id,
		  'likes'	 	 => $item->likes,
        );
      }
    }
    return str_replace('\/','/', $json_string = json_encode($counter, JSON_PRETTY_PRINT));
  }
  
  
  public function search($params) {
    $search   = FALSE;
	$options  = explode(',', $params);
    $spot     = get_spot();
    $mapper   = $spot->mapper('App\Entity\Localization');
    $responseCountry = $mapper->query("SELECT * FROM localizations WHERE country LIKE '%$options[1]%'");
    $responseTags = $mapper->query("SELECT * FROM tags WHERE tag LIKE '%$options[1]%'");
	if (strlen($options[1]) >= 3) {
	  if ($options[0] == 'country') {
	    if (is_object($responseCountry)){
		  $search = array();
		  foreach ($responseCountry as $item) {
			$search[] = (object) array (
			  'id'       => $item->camera_id,
			  'country'  => $item->country,
			  'lat'      => $item->lat,
			  'lng'      => $item->lng,
			);
		  }
		}
	  } 
	  elseif ($options[0] == 'tags') {
		if (is_object($responseTags)){
		  $search = array();
		  foreach ($responseTags as $item) {
		    $search[] = (object) array (
		  	  'id'        => $item->camera_id,
		  	  'tag'		=> $item->tag,
		    );
		  }
	    }
	  } 
	  elseif ($options[0] == 'all') {
		if (is_object($responseTags)){
		  $search = array();
		  foreach ($responseTags as $item) {
		    $search[] = (object) array (
		  	  'id'      => $item->camera_id,
		  	  'tag'		=> $item->tag,
		    );
		  }
		  foreach ($responseCountry as $item) {
		    $search[] = (object) array (
		  	  'id'       => $item->camera_id,
			  'country'  => $item->country,
			  'lat'      => $item->lat,
			  'lng'      => $item->lng,
		    );
		  }
		}
	  }
	}
    return str_replace('\/','/', $json_string = json_encode($search, JSON_PRETTY_PRINT));
  }
  
  public function cacheCamera($id) {
    $camera   = FALSE;
    $spot     = get_spot();
    $mapper   = $spot->mapper('App\Entity\Camera');
    $response = $mapper->get($id);
    if (is_object($response)){
		$img = file_get_contents($response->screen);
		$im = imagecreatefromstring($img);
		$width = imagesx($im);
		$height = imagesy($im);
		$ratio = 250 / $width;
		$newwidth = $width * $ratio;
		$newheight = $height * $ratio;
		$thumb = imagecreatetruecolor($newwidth, $newheight);
		imagecopyresized($thumb, $im, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
		imagejpeg($thumb,'../cache/screen'.$id.'.jpg', 70); //save image as jpg
		imagedestroy($thumb); 
		imagedestroy($im);
    }
    return str_replace('\/','/', $json_string = json_encode($camera, JSON_PRETTY_PRINT));
  }
  
  public function cacheCameras($_ids) {
    $camera   = FALSE;
	$ids 	  = explode(',', $_ids);
	if (is_array($ids) && count($ids) > 1){
		$camera = array();
		$spot     = get_spot();
		$mapper   = $spot->mapper('App\Entity\Camera');
		foreach($ids as $id) {
			$response = $mapper->get($id);
			if (is_object($response)){
				$img = file_get_contents($response->screen);
				$im = imagecreatefromstring($img);
				$width = imagesx($im);
				$height = imagesy($im);
				$ratio = 250 / $width;
				$newwidth = $width * $ratio;
				$newheight = $height * $ratio;
				$thumb = imagecreatetruecolor($newwidth, $newheight);
				imagecopyresized($thumb, $im, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
				imagejpeg($thumb,'../cache/screen'.$id.'.jpg', 70); //save image as jpg
				imagedestroy($thumb); 
				imagedestroy($im);
			}
		}
	}
    return str_replace('\/','/', $json_string = json_encode($camera, JSON_PRETTY_PRINT));
  }
}