<?php
namespace App\Entity;

use \Spot\Entity as Entity;
use \Spot\EntityInterface as Entityi;
use \Spot\MapperInterface as Mapperi;

class Counter extends Entity {
  protected static $table = 'counters';
  protected static $mapper = 'App\Entity\Mapper\Counter';

  public static function fields() {
    return [
      'camera_id'   => ['type' => 'smallint', 'primary' => TRUE],
      'likes' 		=> ['type' => 'integer'],
      'warns' 		=> ['type' => 'integer'],
      'views' 		=> ['type' => 'integer'],
    ];
  }

  public static function relations(Mapperi $mapper, Entityi $entity) {
    return [
      'camera' => $mapper->belongsTo($entity, 'App\Entity\Camera', 'camera_id'),
    ];
  }
}