<?php
namespace App\Entity;

use \Spot\Entity as Entity;
use \Spot\EntityInterface as Entityi;
use \Spot\MapperInterface as Mapperi;

class Tag extends Entity {
  protected static $table = 'tags';
  protected static $mapper = 'App\Entity\Mapper\Tag';

  public static function fields() {
    return [
      'camera_id'   => ['type' => 'smallint', 'primary' => TRUE],
      'tag' 		=> ['type' => 'text'],
    ];
  }

  public static function relations(Mapperi $mapper, Entityi $entity) {
    return [
      'camera' => $mapper->belongsTo($entity, 'App\Entity\Camera', 'camera_id'),
    ];
  }
}