<?php
header('Content-type: text/javascript; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

use Szenis\RouteResolver;
use Szenis\Router;
use Spot\Locator;

require __DIR__.'/../config/db.php';
require __DIR__.'/../vendor/autoload.php';


function get_spot() {
  static $spot;
  if($spot === null) {
    require __DIR__.'/../config/db.php';
    $cfg = new Spot\Config();
    $cfg->addConnection('mysql', $_db);
    $spot = new Locator($cfg);
  }
  return $spot;
}



try {
	$router = new Router();
	require __DIR__.'/../app/routes.php';

	$resolver = new RouteResolver($router);

	$response = $resolver->resolve([
		'uri' => $_SERVER['REQUEST_URI'],
		'method' => $_SERVER['REQUEST_METHOD'],
	]);

	echo $response;

} catch (Szenis\Exceptions\RouteNotFoundException $e) {
	// route not found, add a nice 404 page here if you like 
	die($e->getMessage());
} catch (Szenis\Exceptions\InvalidArgumentException $e) {
	// an exception has been caught, you could log it in a log file and show an 'something went wrong' page
	die($e->getMessage());
}